/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.lib39.core.api;

import com.google.common.base.Ascii;
import com.unascribed.lib39.core.api.util.LatchHolder;
import com.unascribed.lib39.core.api.util.LatchRegistryEntry;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.logging.log4j.util.TriConsumer;

public final class AutoRegistry {
    private final String namespace;

    public static AutoRegistry of(String namespace) {
        return new AutoRegistry(namespace);
    }

    private AutoRegistry(String namespace) {
        this.namespace = namespace;
    }

    public <T> void autoRegister(Consumer<T> adhocRegistry, Class<?> holdingClass, Class<T> type) {
        this.eachRegisterableField(holdingClass, type, null, (f, v, na) -> adhocRegistry.accept(v));
    }

    public <T> void autoRegister(BiConsumer<class_2960, T> registry, Class<?> holdingClass, Class<T> type) {
        this.eachRegisterableField(holdingClass, type, RegisteredAs.class, (f, v, ann) -> registry.accept(this.deriveId((Field)f, (RegisteredAs)ann), v));
    }

    public <T, A extends Annotation> void eachRegisterableField(Class<?> holdingClass, Class<T> type, Class<A> anno, TriConsumer<Field, T, A> cb) {
        for (Field f : holdingClass.getDeclaredFields()) {
            if (!type.isAssignableFrom(f.getType()) || !Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            try {
                f.setAccessible(true);
                cb.accept((Object)f, f.get(null), anno == null ? null : f.getAnnotation(anno));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T> void autoRegister(class_2378<T> registry, Class<?> holdingClass, Class<? super T> type) {
        this.eachRegisterableField(holdingClass, type, RegisteredAs.class, (f, v, ann) -> {
            class_2960 id = this.deriveId((Field)f, (RegisteredAs)ann);
            class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)v);
            this.assignHolder(registry, holdingClass, f.getName() + "_HOLDER", id, LatchHolder.class);
            this.assignHolder(registry, holdingClass, f.getName() + "_ENTRY", id, LatchRegistryEntry.class);
        });
    }

    <T> void assignHolder(class_2378<T> registry, Class<?> holdingClass, String field, class_2960 id, Class<? extends LatchHolder> type) {
        try {
            Field holderField = holdingClass.getDeclaredField(field);
            if (holderField.getType() == LatchHolder.class && Modifier.isStatic(holderField.getModifiers()) && !Modifier.isTransient(holderField.getModifiers())) {
                ((LatchHolder)holderField.get(null)).set(registry.method_40290(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)id)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class_2960 deriveId(Field f, RegisteredAs ann) {
        class_2960 id = ann != null ? (ann.value().contains(":") ? new class_2960(ann.value()) : this.id(ann.value())) : this.id(Ascii.toLowerCase((String)f.getName()));
        return id;
    }

    class_2960 id(String path) {
        return new class_2960(this.namespace, path);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RegisteredAs {
        public String value();
    }
}

